![[Pasted image 20250421103630.png]]

The policies are applied **top down** and **left to right**.
## Introduction
- Cisco Secure Email enforces organizational policies for email messages sent to and from users.
- Utilizes mail flow policies to control email message flow during SMTP conversations.
- Mail policies define rules to identify and act upon suspect, sensitive, or malicious content.

## Mail Policies
##### Types of Content
- Spam, marketing messages, graymail
- Viruses, phishing, targeted mail attacks
- Confidential corporate data, personally identifiable information
##### Policy Creation
- Create multiple policies to meet security needs of different user groups.
- Enforce policies based on sender, recipient, domain, address, or group memberships.
##### Example Usage
- Disable antispam scanning for specific departments.
- Enable scanning and tag suspected spam for others.
- Quarantine or delete messages based on department requirements.
##### Department-specific Policies
- Different departments require tailored inbound and outbound email policies.
- Example: IT staff may quarantine emails with executables; Sales department might delete them.

## Mail Policy Types
##### Incoming Mail Policies
- Process emails received from external mail servers.
##### Outgoing Mail Policies
- Process emails sent from internal users to external mail servers.

## Configuration
##### Cisco Email Security Manager
- Manage all email security services and applications via a comprehensive dashboard.
- Policies defined by email address, domain, or LDAP group queries.
##### Default Policies
- Apply to messages not covered by other explicitly defined policies.
- Custom policies inherit settings from default policies and can be modified.
##### Policy Evaluation
- Policies evaluated in a top-down manner.
- Order affects email processing outcomes.

## Policy Matching
##### Matching Criteria
- Based on recipient and sender addresses.
- Methods for defining senders and recipients include full email address, partial email address, domain, partial domain, or LDAP queries.
##### Message Splintering
- Allows differing recipient-based content security rules.
- Splintering creates new messages for each policy match.
![[Pasted image 20250421151901.png]]

##### Message Actions
- Various actions applied based on scan results and configured settings:
    - Deliver, Quarantine, Bounce, Drop
    - Optional secondary actions: Modify subject, Archive message, etc.

![[Pasted image 20250421152001.png]]

##### Advanced Phishing Protection
- Provides Business Email Compromise (BEC) and phishing detection.
- Utilizes machine learning and intelligence for sender reputation checks.
- Remediates potentially malicious messages based on pre-configured policies.
## Benefits
- Identify, investigate, and remediate threats observed in message headers.
- View reporting data from multiple email gateways within the organization.

